#ifndef CONFIG_H_HEADERGUARD
#define CONFIG_H_HEADERGUARD

// ============================================================================
// ======================= Motor's Steps Per Revolution  ======================
// ============================================================================
//  Set this variable to the number of steps your motor takes in one rotation.
//  Typical stepper motors have 200 steps per rotation.
//  The default value of this variable is 200.
#define STEPS_PER_REVOLUTION_OF_MOTOR 200

// ============================================================================
// ======================= Minimum Rotations Per Minute =======================
// ============================================================================
// The slowest speed you would like the motor to spin. If you set this to a
// slower speed then what is supported then the slowest supported speed will be
// used instead. The minimum supported speed depends on the motor's steps per
// rotation.
#define MINIMUM_RPM 10

// ============================================================================
// ======================= Minimum Rotations Per Minute =======================
// ============================================================================
// The fastest speed you like the motor to spin. Trying to make stepper motor
// spin faster than it is physically capable of will just make it vibrate in
// place.
#define MAXIMUM_RPM 100

// ============================================================================
// ================ Movement Range In Absolute Positioning Mode ===============
// ============================================================================
// When in absolute position mode, this defines the stepper's range of motion.
// Default value is 360 degrees.
#define ABSOLUTE_POSITION_RANGE_IN_DEGREES 360

// ============================================================================
// ================ Movement Speed In Absolute Positioning Mode ===============
// ============================================================================
// When in absolute position mode, this defines at what speed (RPM) the stepper
// should move. The default value is 50.
#define ABSOLUTE_POSITION_MOVE_SPEED 50

// ============================================================================
// ============================ Stepping Method ===============================
// ============================================================================
// Pick one.
// The default is USE_HALF_STEPS
#define USE_HALF_STEPS
//#define USE_FULL_STEPS

#endif //CONFIG_H_HEADERGUARD
