// ****************************************************************************
// This code is distributed under the GNU Public License
//      which can be found at http://www.gnu.org/licenses/gpl.txt
//
// ****************************************************************************

// The pulse manager measures pulse lengths on a pin.

//Hardware resources used:
// Timer1
// INT0 interrupt for state changes on pin PB0


#ifndef PULSEMANAGER_H_HEADERGUARD
#define PULSEMANAGER_H_HEADERGUARD

#include "inttypes.h"
#include "LowPassFilter.h"

class PulseManager
{
public:

    LowPassFilter myLowPassfilter;

             PulseManager();
    bool     available();
    uint16_t getPulseLength();
    bool     wasModeChangePulseDetected();
    bool     wasSignalLossDetected();


    static void timerOverflowISR();
    static void pinStateChangeISR();

private:

    enum state_t
    {
        IDLE = 0,
        TIMING_SERVO_PREAMBLE,
        MEASURING_SERVO_PULSE,
        MEASURING_LONG_PULSE
    };

    //Private functions
    void switchToIdleMode();
    void switchToMeasuringServoPulse();
    void switchToMeasuringLongPulse();
    void switchToTimingServoPulsePreamble();



    //Private variables
    static PulseManager* myThis;                            //pointer to the (one and only) PulseManager object.
    volatile static uint8_t latestPulseLength;
    volatile static bool newPulseMeasurementIsAvailable;    //true when a new pulse length was measured
    volatile static bool modeChangeConditionDetected;       //true when pulse lasts for at least 3 seconds
    volatile static bool signalLossConditionDetected;       //true when there are no pulses for a while
    volatile static state_t state;
    volatile static uint8_t overflowCounter;    //number of timer overflows when measuring a long pulse


};//end PulseManager

#endif //PULSEMANAGER_H_HEADERGUARD
