// ****************************************************************************
// This code is distributed under the GNU Public License
//      which can be found at http://www.gnu.org/licenses/gpl.txt
//
// ****************************************************************************

#include "LowPassFilter.h"

LowPassFilter::LowPassFilter(uint8_t newTimeConstant)
{
    timeConstant = newTimeConstant;
    lastComputedOutput = 0;
}//end constructor




//  Y = Y[n-1] + A * (X - Y[n-1])
// Where Y is the current output, Y[n-1] is the last computed output,
// and X is your latest sensor reading.
uint16_t LowPassFilter::input(uint16_t newValue)
{
    uint16_t currentOutputValue = 0;
    int32_t temp = (int32_t)newValue - (int32_t)lastComputedOutput;
    temp *= timeConstant;
    temp /= 100; //because the time constant is less than 100.

    currentOutputValue = lastComputedOutput + temp;

    lastComputedOutput = currentOutputValue;
    return currentOutputValue;
}//end input



